*produces Figure 17: Cumulative Response of Liquidity Buffer to Monetary Policy Shock
local location "<place directory here>\Financial Accounts LP"

************************
*MONETARY POLICY SHOCKS
************************
import excel using "`location'\rr_shocks.xlsx", clear 

rename A date 
rename B cratech 
rename E btcs 
rename C bt 

drop in 1 

g year= substr(date,6,4)
g q1 = substr(date,3,3)

g q = 1 if q1 == "jan"
replace q = 1 if q1 == "feb"
replace q = 1 if q1 == "mar"
replace q = 2 if q1 == "apr"
replace q = 2 if q1 == "may"
replace q = 2 if q1 == "jun"
replace q = 3 if q1 == "jul"
replace q = 3 if q1 == "aug"
replace q = 3 if q1 == "sep"
replace q = 4 if q1 == "oct"
replace q = 4 if q1 == "nov"
replace q = 4 if q1 == "dec"

keep year q cratech bt*
destring year cratech bt*, replace 
g qtr = yq(year,q)
format qtr %tq 
collapse(sum) cratech bt*, by(qtr)
save "`location'\mpshocks.dta", replace


******************************
*ABS HOUSEHOLD INCOME 
******************************
import excel using "`location'\5206020_Household_Income.xls", clear sheet(Data1)

rename A date
rename DJ hhdy
rename DK hcon
rename BH minterest

keep date hhdy hcon mint 
drop in 1/10
g year = substr(date,6,4)
g q1 = substr(date,3,3)

g q = 1 if q1 == "mar"
replace q = 2 if q1 == "jun"
replace q = 3 if q1 == "sep"
replace q = 4 if q1 == "dec"

destring year, replace

destring hcon hhdy mint,replace
gen qtr=yq(year,q)
format %tq qtr

replace hcon = hcon/1000
replace hhdy = hhdy/1000
replace mint = mint/1000
keep qtr year q hcon hhdy mint

save "`location'\hhdytemp.dta", replace

******************************
*ABS FIN ACCOUNTS 
******************************
import excel using "`location'\5232035.xls" ,clear sheet(Data1)
rename A date
rename B assets
rename AF resassets
rename T currency_deposits
rename U bonds
rename V loans
rename W equities
rename AC debt
rename AE networth 
keep date assets resassets currency bonds loans equities debt networth
drop in 1/10
g year = substr(date,6,4)
g q1 = substr(date,3,3)

g q = 1 if q1 == "mar"
replace q = 2 if q1 == "jun"
replace q = 3 if q1 == "sep"
replace q = 4 if q1 == "dec"

destring year assets resassets currency bonds loans equities debt networth, replace
gen qtr=yq(year,q)
format %tq qtr

keep qtr year q assets resassets currency bonds loans equities debt networth

merge 1:1 qtr using "`location'\hhdytemp.dta", nogen keep(match master)
merge 1:1 qtr using "`location'\mpshocks.dta", nogen keep(match master)
erase "`location'\hhdytemp.dta"
erase "`location'\mpshocks.dta"


g id = 1
tsset id qtr 

g liqassets = cur+bonds+loans+equities
g liqratio = liqasset/hhdy
g liqshare = liqassets/assets

g lhhdy = log(hhdy)

g mp = btcs

forvalues i = 0/20{
g f`i'liqratio = f`i'.liqratio-l.liqratio
g f`i'liqshare = f`i'.liqshare-l.liqshare
}

foreach x in liqratio {
forv h = 0/20 {
*Use for cumulative IRF
gen `x'`h' = f`h'.`x' - l.`x'                        
*Use for usual IRF
*gen `x'`h' = f`h'.`x' - l.f`h'.`x'
}
}


*eststo clear
cap drop b u d Years Zero
gen Years = _n-1 if _n<=21
gen Zero =  0    if _n<=21
gen b=0
gen u=0
gen d=0
forv h = 0/20 {
reg f`h'liqratio mp l1.hhdy l1.liqassets i.q d.lhhdy, robust
replace b = _b[mp]                     if _n == `h'+2
replace u = _b[mp] + 1.645* _se[mp]  if _n == `h'+2
replace d = _b[mp] - 1.645* _se[mp]  if _n == `h'+2
replace b = b*-1                 if _n == `h'+2
replace u = u*-1                 if _n == `h'+2
replace d = d*-1                 if _n == `h'+2
}
preserve 
keep Years b u d 
drop if Years == . 
outsheet using "`location'\irf_liqratio.csv", replace comma 
restore 

twoway (rarea u d  Years,  fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) (line b Years, lcolor(blue) lpattern(solid) lwidth(thick)) (line Zero Years, lcolor(black)), legend(off) title("Response of Liquidity Buffer to 1pp MP Shock", color(black) size(medsmall)) ytitle("Percent", size(medsmall)) xtitle("Quarter", size(medsmall)) graphregion(color(white)) plotregion(color(white)) 
                      gr rename g_gdpr , replace
                      



